/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.modemcfg;

import com.ibm.hwmca.base.modemcfg.AdvancedModemConfigBean;
import com.ibm.hwmca.base.modemcfg.ModemConfigActions;
import com.ibm.hwmca.base.modemcfg.ModemConfigBean;
import com.ibm.hwmca.base.modemcfg.ModemConfigData;
import com.ibm.hwmca.base.modemcfg.ModemConfigErrorIds;
import com.ibm.hwmca.base.modemcfg.ModemTestBean;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class ModemConfigTasklet
extends PanelTasklet
implements ModemConfigErrorIds,
ModemConfigActions {
    private static final String TRACE_MASKT = "HMCGTLTT";
    private static final String TRACE_MASKF = "HMCGTLTF";
    private static final String TRACE_MASKD = "HMCGTLTD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-89, "ModemCfgTklt");
    private static final String AUIML = "com.ibm.hwmca.base.modemcfg.res.ModemConfigRes";
    private static final String CONFIG_PANEL = "ModemConfigPanel";
    private static final String ADVANCED_PANEL = "AdvancedModemConfigPanel";
    private static final String TEST_PANEL = "ModemTestResultsPanel";
    private static final String PARENT_BEAN = "BASETOWERSETTINGSBEAN";

    public ModemConfigTasklet() {
        Trace.trace(TRACE_MASKT, "<-> ModemConfigTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "--> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                ModemConfigBean bean = new ModemConfigBean();
                bean.setBeanName("config");
                ModemConfigData data = ModemConfigData.getModemConfigData();
                if (User.getUser().hasAuth("base.rolegroup.acsadmin") || User.getUser().hasAuth("base.rolegroup.pedebug")) {
                    bean.setAccess(true);
                }
                bean.setDialToneTypeId(data.getDialToneTypeId());
                bean.setDialPrefixEdit(data.getDialPrefix());
                response.replace(AUIML, CONFIG_PANEL, bean);
            } else if (request.isDisposed() || request.isCanceled()) {
                PanelTaskletRequest newRequest = new PanelTaskletRequest();
                newRequest.setDisposed();
                if (this.isSubtasklet()) {
                    this.getParent().postRequest(PARENT_BEAN, newRequest);
                }
                response.terminate();
            } else {
                String source = (String)request.getData("source");
                String action = (String)request.getData("action");
                Trace.trace(TRACE_MASKF, "source=" + source + ", action=" + action);
                if (source.equals("config")) {
                    if (action.equals("commit")) {
                        ModemConfigBean bean = (ModemConfigBean)request.getData("bean");
                        ModemConfigData data = ModemConfigData.getModemConfigData();
                        data.setDialToneTypeId(bean.getDialToneTypeId());
                        data.setDialPrefix(bean.getDialPrefixEdit());
                        data.persistData();
                        PanelTaskletRequest newRequest = new PanelTaskletRequest();
                        newRequest.setDisposed();
                        if (this.isSubtasklet()) {
                            this.getParent().postRequest(PARENT_BEAN, newRequest);
                        }
                        response.terminate();
                    } else if (action.equals("advanced_config")) {
                        AdvancedModemConfigBean bean = new AdvancedModemConfigBean();
                        ModemConfigData data = ModemConfigData.getModemConfigData();
                        bean.setBeanName("advanced");
                        bean.setPortSpeedId(data.getPortSpeedId());
                        bean.setDataBitsId(data.getDataBitsId());
                        bean.setParityId(data.getParityId());
                        bean.setStopBitsId(data.getStopBitsId());
                        bean.setFlowControlId(data.getFlowControlId());
                        bean.setBlindDialId(data.getBlindDialId());
                        bean.setSpeakerVolumeId(data.getSpeakerVolumeId());
                        bean.setInitStringEdit(data.getInitString());
                        response.openModalChild(AUIML, ADVANCED_PANEL, bean);
                    }
                } else if (source.equals("advanced")) {
                    if (action.equals("commit")) {
                        AdvancedModemConfigBean bean = (AdvancedModemConfigBean)request.getData("bean");
                        ModemConfigData data = ModemConfigData.getModemConfigData();
                        data.setPortSpeedId(bean.getPortSpeedId());
                        data.setDataBitsId(bean.getDataBitsId());
                        data.setParityId(bean.getParityId());
                        data.setStopBitsId(bean.getStopBitsId());
                        data.setFlowControlId(bean.getFlowControlId());
                        data.setBlindDialId(bean.getBlindDialId());
                        data.setSpeakerVolumeId(bean.getSpeakerVolumeId());
                        data.setInitString(bean.getInitStringEdit());
                        data.persistData();
                        response.dispose();
                    } else if (action.equals("test_modem")) {
                        ModemTestBean bean = new ModemTestBean();
                        bean.setBeanName("test");
                        response.openModalChild(AUIML, TEST_PANEL, bean);
                    } else if (action.equals("cancel")) {
                        response.dispose();
                    }
                } else if (source.equals("test")) {
                    if (action.equals("cancel")) {
                        response.dispose();
                    }
                } else {
                    response.noAction();
                }
            }
        }
        catch (Exception e) {
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 3, texc).log();
            throw texc;
        }
        Trace.trace(TRACE_MASKT, "<-- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "--> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 1, throwable).log();
        Trace.trace(TRACE_MASKT, "<-- logException()");
    }
}

